<?php

namespace VM\AdminBundle\Controller;

use FOS\RestBundle\Controller\Annotations\View;
use VM\AdminBundle\Services\ApiGetter;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Entity\UserGroups;

class SettingsController extends AbstractController
{
    /**
     * @View()
     */
    public function getAllSettingsAction()
    {
        return $this->getDoctrine()->getRepository('VMApiBundle:MarketSegment')->findAll();
    }

    /**
     * @View()
     */
    public function getSelectedMarketSegmentAction()
    {
        return $this->getUser()->getMarketSegment();
    }

    /**
     * @View()
     */
    public function saveMarketSegmentAction()
    {
        $ApiGetter = $this->getApiGetter();
        $User = $this->getUser();
        $MarketSegment = $this->getUser()->getMarketSegment();

        try
        {
            if(!empty($MarketSegment) && $this->isAnyCompanyCreate($User))
            {
                throw new \Exception('Nie można zmieniać segmentu, gdyż zostały już utworzone firmy', 12);
            }

            $itemData = $this->getRequest()->request->getIterator()->getArrayCopy();
            $MarketSegment = $ApiGetter->getMarketSegment($itemData['id']);

            if($MarketSegment->getSymbol() != 'AUTO')
            {
                throw new \Exception('Nie można wybrać tego segmentu', 13);
            }

            $User->setMarketSegment($MarketSegment);
            $this->getDoctrine()->getManager()->flush();
            return $MarketSegment;
        }
        catch(\Exception $Exception){

            $data = array('id' => $MarketSegment->getId(), 'name' => $MarketSegment->getName());
            $data['error'] = array('message' => $Exception->getMessage(), 'code' => $Exception->getCode());

            return $data;
        }
    }


    /**
     * @param User $User
     * @return bool
     */
    protected function isAnyCompanyCreate(User $User)
    {
        $groups = $User->getAdminGroups();
        foreach($groups as $Group)
        {
            foreach($Group->getUsers() as $Student)
            {
                $Company = $Student->getCreatorCompany();
                if(count($Company) > 0)
                {
                    return true;
                }
            }
        }

        return false;
    }
}
